 IF EXISTS
(
    SELECT 1
    FROM SYS.VIEWS
    WHERE NAME = 'V_TENTACLE_SYNC_MONITOR'
)
    BEGIN
        DROP VIEW V_TENTACLE_SYNC_MONITOR;
    END;
GO
--SELECT * FROM V_TENTACLE_SYNC_MONITOR
CREATE VIEW V_TENTACLE_SYNC_MONITOR AS
SELECT
	AGENTE,
	TABELA AS TABELA_SQL_SERVER,
	TABELA_DEST AS TABELA_POSTGRES,
	DATE_REG as DATA_REGISTRO,
	CASE WHEN STATUS=1 THEN
		'APLICADA'
	ELSE
		CASE WHEN LAST_ERROR IS NULL THEN
			'PENDENTE'
		ELSE
			'ERRO NA APLICACAO'
		END
	END AS STATUS,
	ISNULL(LAST_ERROR,'') AS ERRO,
	CASE WHEN STATUS=1 THEN
	0
	ELSE
		DATEDIFF(mi, DATE,GETDATE())
	END AS TEMPOESPERAMINUTOS,
	CASE WHEN STATUS=0 THEN
		0
	ELSE
		DATEDIFF(mi, DATE_REG,DATE_STATUS) END AS TEMPORESPOSTALOJAMINUTOS,
	SYNC_VERSION AS AGENTE_MATRIZ_ENVIO,
	AGENTE_VERSION AS AGENTE_LOJA,
	4 - DATEDIFF(HH, DATE_REG,getdate()) as TEMPOPARAAPAGARHORAS
FROM
	TENTACLE_SYNC_MONITOR


